@extends('admin.layout.template')
@section('title', 'Project Details')
@section('content')

<div class="page-content">
    <div class="container-xxl">

        <div class="card mb-4">
            <div class="card-header">
                <h4>{{ $project->project_name }} ({{ $project->project_number }})</h4>
            </div>
            <div class="card-body">
                <p><strong>Customer:</strong> {{ $project->customer_name }} ({{ $project->customer_phone }})</p>
                <p><strong>Address:</strong> {{ $project->address }}</p>
                <p><strong>Expected Completion:</strong> {{ $project->expected_completion_date }}</p>
                <p><strong>Project Type:</strong> {{ $project->project_type }}</p>
            </div>
        </div>

        @foreach($project->areas as $area)
        <div class="card mb-3">
            <div class="card-header">
                <h5>Area: {{ $area->area_name }} @if($area->room) (Room: {{ $area->room->name }}) @endif</h5>
            </div>
            <div class="card-body">
                @if($area->items->count() > 0)
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Category</th>
                            <th>Product</th>
                            <th>Variant</th>
                            <th>Quantity</th>
                            <th>Measurement</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($area->items as $item)
                        <tr>
                            <td>{{ $loop->iteration }}</td>
                            <td>{{ ucfirst($item->category) }}</td>
                            <td>{{ $item->product?->name }}</td>
                            <td>{{ $item->variant?->sku }}</td>
                            <td>{{ $item->quantity }}</td>
                            <td>
                                @if($item->measurement)
                                    W: {{ $item->measurement->width ?? '-' }} 
                                    H: {{ $item->measurement->height ?? '-' }} 
                                    L: {{ $item->measurement->length ?? '-' }}
                                @else
                                    -
                                @endif
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
                @else
                <p>No items added for this area.</p>
                @endif
            </div>
        </div>
        @endforeach

        <a href="{{ route('projects.index') }}" class="btn btn-secondary mt-3">Back to Projects</a>

    </div>
</div>

@endsection
